-- =========================================================
-- Custom View Settings & Cinematic Camera Tweaks
-- Author  : AsilTurq
-- Purpose : Top Gun style cinematic cockpit & camera views
-- Notes   : Head movement limits adjusted for filming
-- =========================================================
-- =========================================================
-- Özel Kamera ve Görüş Ayarları
-- Hazırlayan : AsilTurq
-- Amaç       : Sinematik / Top Gun tarzı çekimler
-- Not        : Kafa ve kamera davranışları düzenlenmiştir
-- =========================================================




-- View scripts 
-- Copyright (C) 2004, Eagle Dynamics.
DisableCombatViews				= false -- F5 & Ctrl-F5
ExternalObjectsLockDistance 	= 10000.0
ShowTargetInfo 					= false
CameraTerrainRestriction 		= false
hAngleCustomDefault 			=  0.0
vAngleCustomDefault 			= -8.0
vAngleCustomMin    				= -90.0
vAngleCustomMax    				= 90.0

UseGreenieBoardLandingDataHistory = true	-- For Carrier Air Wing Briefing Room
UseKillBoardDataHistory = true

--reformatted per-unit data to be mod system friendly 
--this file is no longer should be edited for adding new flyable aircraft , DCS automatically check core database (i.e. where you define your aircraft in aircraft table just define ViewSettings and SnapViews tables)

function default_fighter_player(t)
	local res = { 
		CameraViewAngleLimits  = {20.000000,140.000000},
		CameraAngleRestriction = {false	   ,90.000000,0.500000},
		EyePoint               = {0.05     ,0.000000 ,0.000000},
		--limits_6DOF            = {x = {-0.050000,0.4500000},y ={-0.300000,0.100000},z = {-0.220000,0.220000},roll = 90.000000},
		limits_6DOF            = {x = {-100.050000,100.4500000},y ={-100.300000,100.100000},z = {-100.220000,100.220000},roll = 90.000000},
		--Allow360rotation	   = false,
		Allow360rotation	   = true,
		CameraAngleLimits      = {200,-80.000000,110.000000},
		ShoulderSize 		   = 0.2,  -- move body when azimuth value more then 90 degrees
	}
	if t then 
		for i,o in pairs(t) do
			res[i] = o
		end
	end
	return res
end

function fulcrum()
	return {
		Cockpit = {
			default_fighter_player({CockpitLocalPoint = {4.71,1.28,0.000000}})
		},
		Chase   = {
			LocalPoint      = {1.220000,3.750000,0.000000},
			AnglesDefault   = {180.000000,-8.000000},
		}, -- Chase 
		Arcade = {
			LocalPoint      = {-15.080000,6.350000,0.000000},
			AnglesDefault   = {0.000000,-8.000000},
		}, -- Arcade 
	}
end

ViewSettings = {}

ViewSettings["F-16C_50"] = {
	Cockpit = {
	[1] = {-- player slot 1
		CameraViewAngleLimits  = {20.000000,140.000000},
		CockpitLocalPoint      = {3.259,0.796,0.0},
		CameraAngleRestriction = {false,90.000000,0.500000},
		CameraAngleLimits      = {200,-90.000000,90.000000},
		EyePoint               = {0.05000,0.100000,0.000000},
		ShoulderSize		   = 0.25,
		--Allow360rotation	   = false,
		Allow360rotation	   = true,
		--limits_6DOF            = {x = {-0.13,0.30},y ={-0.06,0.16},z = {-0.18,0.18},roll = 90.000000},
		limits_6DOF            = {x = {-100.13,100.30},y ={-100.06,100.16},z = {-100.18,100.18},roll = 90.000000},
	},
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-5.0,1.0,3.0},
		AnglesDefault   = {0.000000,0.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-21.500000,5.618000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}